function CDX = set_zero_RP_pJTD_and_COR(CDX)
% --------------------------------------------------------------------------------------------------
% Set the pure JTD and correlation risk premium equal to zero.
% --------------------------------------------------------------------------------------------------
% CDX                       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_pJTD_and_COR(cdx_tv_monthly10)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    if (~isempty(cds.bi_P))
        cds.bi = cds.bi_P;
    end
    if (~isempty(cds.ai_P))
        cds.ai = cds.ai_P;
    end
    CDX.portfolio(i) = cds;
end